// waitForElm modified from: https://stackoverflow.com/questions/5525071/how-to-wait-until-an-element-exists
function waitForElm(selector) {
    return new Promise(resolve => {
        const el = document.querySelector(selector)
        if (el) {
            return resolve(el);
        }

        const observer = new MutationObserver(mutations => {
            const el = document.querySelector(selector);
            if (el) {
                observer.disconnect();
                resolve(el);
            }
        });

        observer.observe(document, {
            childList: true,
            subtree: true
        });
    });
}

function addBlockerEl(post) {
    if (post.querySelector('.bsky-image-hider-extension-blocker')) {
        return;
    }

    const images = Array.from(post.querySelectorAll('div[data-expoimage]'));

    const videos = Array.from(post.querySelectorAll('div')).filter(x => x.style.backgroundImage.includes('https://video.bsky.app'))

    const toHide = images.concat(videos);

    toHide.forEach(el => {
        const computedStyle = getComputedStyle(el);

        const blocker = document.createElement('div');

        blocker.style.height = computedStyle.height;
        blocker.style.width = computedStyle.width;

        blocker.classList.add('bsky-image-hider-extension-blocker');


        blocker.addEventListener('click', (e) => {
            e.preventDefault();
            e.stopPropagation();
            blocker.style.opacity = 0;
        }, { once: true });

        const msg = document.createElement('div');
        msg.innerText = "click to view";

        blocker.appendChild(msg);
        el.after(blocker);
    })
};


async function blockPosts() {
    // We're relying on an attribute added by bluesky to identify posts on the page.
    // This is super brittle, and will break when they change things. I think it'll
    // just be a cat-and-mouse game over time, and we'll have to keep updating the
    // selector.
    //
    // Selectors tried in the past:
    //    * 'div[role="link"]' (sadly only works on profile pages)
    const postSelector = 'div[data-testid="contentHider-post"],div[data-testid^="postThreadItem"]';
    await waitForElm(postSelector);

    const posts = document.querySelectorAll(postSelector);

    // this is also super brittle
    const postsList = posts[0].parentElement.parentElement.parentElement.parentElement.parentElement.parentElement.parentElement;

    posts.forEach(addBlockerEl);

    // block new posts when infinite scroll loads more
    const ifObserver = new MutationObserver(mutationList => {
        for (const mutation of mutationList) {
            mutation.addedNodes.forEach(x => {
                addBlockerEl(x);
            });
        }
    });
    ifObserver.observe(postsList, { childList: true });

    // block posts when SPA navigation happens
    const oldURL = location.href;
    const spaNavigationObserver = new MutationObserver(async () => {
        const url = location.href;
        if (url !== oldURL) {
            const posts = document.querySelectorAll(postSelector);
            posts.forEach(addBlockerEl);
        }
    });
    spaNavigationObserver.observe(document, { subtree: true, childList: true });
}

blockPosts();
